package benchmarks;

import java.io.IOException;

import edu.vub.at.actors.eventloops.Callable;
import edu.vub.at.actors.natives.ELActor;
import edu.vub.at.actors.natives.ELVirtualMachine;
import edu.vub.at.actors.natives.Packet;
import edu.vub.at.actors.natives.SharedActorField;
import edu.vub.at.eval.Evaluator;
import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.objects.ATObject;
import edu.vub.at.objects.ATTable;
import edu.vub.at.objects.ATTypeTag;
import edu.vub.at.objects.coercion.NativeTypeTags;
import edu.vub.at.objects.mirrors.NativeClosure;
import edu.vub.at.objects.natives.NATNumber;
import edu.vub.at.objects.natives.NATObject;
import edu.vub.at.objects.natives.NATTable;
import edu.vub.at.objects.natives.NATText;
import edu.vub.at.objects.natives.grammar.AGSymbol;
import edu.vub.at.parser.NATParser;

public class TestClasses {

	public NATText boeTXT;
	public ATTable coercer;
	public NATObject isolete;
	public NATTable natTable10;
	public NATTable natTable100;
	
	public Packet serializedBoeTXT;
	public Packet serializedCoercer;
	public Packet serializedIsolet;
	public Packet serializedNATTable10;
	public Packet serializedNATTable100;
	
	public TestClasses() throws InterpreterException, IOException {
		boeTXT = NATText.atValue("boe");
		isolete = new NATObject(new ATTypeTag[] { NativeTypeTags._ISOLATE_, NativeTypeTags._TABLE_ });
		coercer = isolete.asTable();
		ATObject[] array1 = new ATObject[10];
		ATObject[] array2 = new ATObject[100];
		for(int i = 0; i < 10; i++){
			array1[i] = NATNumber.atValue(i);
		}
		for(int i = 0; i < 100; i++){
			array2[i] = NATNumber.atValue(i);
		}
		natTable10 = NATTable.atValue(array1);
		natTable100 = NATTable.atValue(array2);
		
		serializedBoeTXT = new Packet("test", boeTXT);
		serializedCoercer = new Packet("test", coercer);
		serializedIsolet = new Packet("test", isolete);
		serializedNATTable10 = new Packet("test", natTable10);
		serializedNATTable100 = new Packet("test", natTable100);

	}
	

}